// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanAttributionMetrics_h
#define mozilla_GleanAttributionMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace glean_attribution {
  /**
   * generated from glean.attribution.ext
   */

  struct ExtObject {
    Maybe<nsCString> experiment;
    Maybe<nsCString> variation;
    Maybe<nsCString> ua;
    Maybe<nsCString> dltoken;
    Maybe<bool> msstoresignedin;
    Maybe<nsCString> dlsource;
  };
  /**
   * Extended attribution information.
   * Mapped to client_info.attribution.ext in datasets.
   * * `experiment`: name/id of the enrolled funnel experiment
   * * `variation`: name/id of the variation cohort used in the enrolled funnel experiment
   * * `ua`: identifier derived from the user agent downloading the installer
   *         e.g. chrome, Google Chrome 123
   * * `dltoken`: Unique token created at Firefox download time.
   *              e.g. c18f86a3-f228-4d98-91bb-f90135c0aa9c
   * * `msstoresignedin`: only present if the installation was done through the Microsoft Store,
   *                      and was able to retrieve the "campaign ID" it was first installed with.
   *                      This value is "true" if the user was signed into the Microsoft Store
   *                      when they first installed, and false otherwise.
   * * `dlsource`: identifier that indicate where installations of Firefox originate
   */
  constexpr impl::ObjectMetric<ExtObject, struct ExtObjectTag> ext(246);
}

template <>
inline void impl::ObjectMetric<glean_attribution::ExtObject, glean_attribution::ExtObjectTag>::Set(const glean_attribution::ExtObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.experiment.isSome()) {
      writer.StringProperty("experiment", *(aObj.experiment));
    }
    if (aObj.variation.isSome()) {
      writer.StringProperty("variation", *(aObj.variation));
    }
    if (aObj.ua.isSome()) {
      writer.StringProperty("ua", *(aObj.ua));
    }
    if (aObj.dltoken.isSome()) {
      writer.StringProperty("dltoken", *(aObj.dltoken));
    }
    if (aObj.msstoresignedin.isSome()) {
      writer.BoolProperty("msstoresignedin", *(aObj.msstoresignedin));
    }
    if (aObj.dlsource.isSome()) {
      writer.StringProperty("dlsource", *(aObj.dlsource));
    }
  }
  writer.EndObject();


  SetStr(json);
}

namespace glean_distribution {
  /**
   * generated from glean.distribution.ext
   */
  using ExtObjectPartnernames = nsTArray<nsCString>;


  struct ExtObject {
    Maybe<nsCString> distributionVersion;
    Maybe<nsCString> partnerId;
    Maybe<nsCString> distributor;
    Maybe<nsCString> distributorChannel;
    Maybe<ExtObjectPartnernames> partnerNames;
  };
  /**
   * Extended distribution information.
   * Mapped to client_info.distribution.ext in datasets.
   * * `distributionVersion`: pref `distribution.version`, `null` on failure
   * * `partnerId`: pref `mozilla.partner.id`, `null` on failure
   * * `distributor`:  pref `app.distributor`, `null` on failure
   * * `distributorChannel`: pref `app.distributor.channel`, `null` on failure
   * * `partnerNames`: list from prefs `app.partner.<name>=<name>`
   */
  constexpr impl::ObjectMetric<ExtObject, struct ExtObjectTag> ext(247);
}

template <>
inline void impl::ObjectMetric<glean_distribution::ExtObject, glean_distribution::ExtObjectTag>::Set(const glean_distribution::ExtObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.distributionVersion.isSome()) {
      writer.StringProperty("distributionVersion", *(aObj.distributionVersion));
    }
    if (aObj.partnerId.isSome()) {
      writer.StringProperty("partnerId", *(aObj.partnerId));
    }
    if (aObj.distributor.isSome()) {
      writer.StringProperty("distributor", *(aObj.distributor));
    }
    if (aObj.distributorChannel.isSome()) {
      writer.StringProperty("distributorChannel", *(aObj.distributorChannel));
    }
    if (aObj.partnerNames.isSome()) {
      writer.StartArrayProperty("partnerNames");
      for (const auto& aobjPartnernamesItem: *aObj.partnerNames) {
        writer.StringElement(aobjPartnernamesItem);

      }
      writer.EndArray();
    }
  }
  writer.EndObject();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanAttributionMetrics_h
