/* THIS FILE IS AUTOGENERATED FROM ElementInternals.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ElementInternalsBinding_h
#define mozilla_dom_ElementInternalsBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class ElementInternals;
class File;
class FormData;
struct NativePropertyHooks;
class OwningFileOrUSVStringOrFormData;
class ProtoAndIfaceCache;
struct ValidityStateFlagsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningFileOrUSVStringOrFormData& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningFileOrUSVStringOrFormData& aUnion);


class FileOrUSVStringOrFormData
{
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eUSVString,
    eFormData
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eUSVString = TypeOrUninit::eUSVString,
    eFormData = TypeOrUninit::eFormData
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;
    UnionMember<NonNull<mozilla::dom::FormData> > mFormData;

  };

  TypeOrUninit mType;
  Value mValue;

  FileOrUSVStringOrFormData(const FileOrUSVStringOrFormData&) = delete;
  FileOrUSVStringOrFormData& operator=(const FileOrUSVStringOrFormData&) = delete;
public:
  explicit inline FileOrUSVStringOrFormData()
    : mType(eUninitialized)
  {
  }

  inline ~FileOrUSVStringOrFormData()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline NonNull<mozilla::dom::FormData>&
  RawSetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline NonNull<mozilla::dom::FormData>&
  SetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    Uninit();
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline NonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline mozilla::dom::FormData&
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
      case eFormData: {
        DestroyFormData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    mValue.mFormData.Destroy();
    mType = eUninitialized;
  }
};


class OwningFileOrUSVStringOrFormData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningFileOrUSVStringOrFormData& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eFile,
    eUSVString,
    eFormData
  };
public:
  enum class Type
  {
    eFile = TypeOrUninit::eFile,
    eUSVString = TypeOrUninit::eUSVString,
    eFormData = TypeOrUninit::eFormData
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<nsString > mUSVString;
    UnionMember<OwningNonNull<mozilla::dom::FormData> > mFormData;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningFileOrUSVStringOrFormData()
    : mType(eUninitialized)
  {
  }

  OwningFileOrUSVStringOrFormData(OwningFileOrUSVStringOrFormData&& aOther);

  explicit inline OwningFileOrUSVStringOrFormData(const OwningFileOrUSVStringOrFormData& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningFileOrUSVStringOrFormData()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_RELEASE_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  OwningNonNull<mozilla::dom::FormData>&
  RawSetAsFormData();

  OwningNonNull<mozilla::dom::FormData>&
  SetAsFormData();

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline OwningNonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline OwningNonNull<mozilla::dom::FormData> const &
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningFileOrUSVStringOrFormData&
  operator=(OwningFileOrUSVStringOrFormData&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningFileOrUSVStringOrFormData&
  operator=(const OwningFileOrUSVStringOrFormData& aOther);

private:
  bool
  TrySetToFile(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFile(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFile();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFormData();
};


struct ValidityStateFlags : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mBadInput;
  MOZ_INIT_OUTSIDE_CTOR bool mCustomError;
  MOZ_INIT_OUTSIDE_CTOR bool mPatternMismatch;
  MOZ_INIT_OUTSIDE_CTOR bool mRangeOverflow;
  MOZ_INIT_OUTSIDE_CTOR bool mRangeUnderflow;
  MOZ_INIT_OUTSIDE_CTOR bool mStepMismatch;
  MOZ_INIT_OUTSIDE_CTOR bool mTooLong;
  MOZ_INIT_OUTSIDE_CTOR bool mTooShort;
  MOZ_INIT_OUTSIDE_CTOR bool mTypeMismatch;
  MOZ_INIT_OUTSIDE_CTOR bool mValueMissing;

  ValidityStateFlags();

  explicit inline ValidityStateFlags(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ValidityStateFlags(ValidityStateFlags&& aOther) = default;

  explicit inline ValidityStateFlags(const ValidityStateFlags& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ValidityStateFlags&
  operator=(const ValidityStateFlags& aOther);

  bool
  operator==(const ValidityStateFlags& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ValidityStateFlagsAtoms* atomsCache);
};

namespace binding_detail {
struct FastValidityStateFlags : public ValidityStateFlags
{
  inline FastValidityStateFlags()
    : ValidityStateFlags(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ElementInternals_Binding {

  typedef mozilla::dom::ElementInternals NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::ElementInternals* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::ElementInternals,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ElementInternals,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ElementInternals,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ElementInternals_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_ElementInternalsBinding_h
