/* THIS FILE IS AUTOGENERATED FROM Window.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_WindowBinding_h
#define mozilla_dom_WindowBinding_h

#include "MessagePortBinding.h"
#include "js/CallAndConstruct.h"
#include "jsapi.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RemoteObjectProxy.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/WindowProxyHolder.h"

class nsGlobalWindowInner;

namespace mozilla {
namespace dom {

class Event;
class External;
class IdleDeadline;
class IdleRequestCallback;
struct IdleRequestOptionsAtoms;
struct NativePropertyHooks;
class OwningEventOrUndefined;
class OwningExternalOrWindowProxy;
class PromiseDocumentFlushedCallback;
class ProtoAndIfaceCache;
struct ScrollOptionsAtoms;
struct ScrollToOptionsAtoms;
struct SizeToContentConstraintsAtoms;
struct WindowPostMessageOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class ScrollBehavior : uint8_t {
  Auto,
  Instant,
  Smooth,
  EndGuard_
};

namespace ScrollBehaviorValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ScrollBehavior::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ScrollBehavior stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ScrollBehaviorValues

bool
ToJSValue(JSContext* aCx, ScrollBehavior aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningEventOrUndefined& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningExternalOrWindowProxy& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningEventOrUndefined& aUnion);


void
ImplCycleCollectionUnlink(OwningExternalOrWindowProxy& aUnion);


class EventOrUndefined
{
  enum TypeOrUninit
  {
    eUninitialized,
    eEvent,
    eUndefined
  };
public:
  enum class Type
  {
    eEvent = TypeOrUninit::eEvent,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Event> > mEvent;

  };

  TypeOrUninit mType;
  Value mValue;

  EventOrUndefined(const EventOrUndefined&) = delete;
  EventOrUndefined& operator=(const EventOrUndefined&) = delete;
public:
  explicit inline EventOrUndefined()
    : mType(eUninitialized)
  {
  }

  inline ~EventOrUndefined()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Event>&
  RawSetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline NonNull<mozilla::dom::Event>&
  SetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    Uninit();
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline NonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline mozilla::dom::Event&
  GetAsEvent() const
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eEvent: {
        DestroyEvent();
        break;
      }
      case eUndefined: {
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyEvent()
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    mValue.mEvent.Destroy();
    mType = eUninitialized;
  }
};


class OwningEventOrUndefined : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningEventOrUndefined& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eEvent,
    eUndefined
  };
public:
  enum class Type
  {
    eEvent = TypeOrUninit::eEvent,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Event> > mEvent;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningEventOrUndefined()
    : mType(eUninitialized)
  {
  }

  OwningEventOrUndefined(OwningEventOrUndefined&& aOther);

  explicit inline OwningEventOrUndefined(const OwningEventOrUndefined& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningEventOrUndefined()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Event>&
  RawSetAsEvent();

  OwningNonNull<mozilla::dom::Event>&
  SetAsEvent();

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline OwningNonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline OwningNonNull<mozilla::dom::Event> const &
  GetAsEvent() const
  {
    MOZ_RELEASE_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningEventOrUndefined&
  operator=(OwningEventOrUndefined&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningEventOrUndefined&
  operator=(const OwningEventOrUndefined& aOther);

private:
  bool
  TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyEvent();
};


class ExternalOrWindowProxy
{
  enum TypeOrUninit
  {
    eUninitialized,
    eExternal,
    eWindowProxy
  };
public:
  enum class Type
  {
    eExternal = TypeOrUninit::eExternal,
    eWindowProxy = TypeOrUninit::eWindowProxy
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::External> > mExternal;
    UnionMember<mozilla::dom::WindowProxyHolder > mWindowProxy;

  };

  TypeOrUninit mType;
  Value mValue;

  ExternalOrWindowProxy(const ExternalOrWindowProxy&) = delete;
  ExternalOrWindowProxy& operator=(const ExternalOrWindowProxy&) = delete;
public:
  explicit inline ExternalOrWindowProxy()
    : mType(eUninitialized)
  {
  }

  inline ~ExternalOrWindowProxy()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::External>&
  RawSetAsExternal()
  {
    if (mType == eExternal) {
      return mValue.mExternal.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eExternal;
    return mValue.mExternal.SetValue();
  }

  inline NonNull<mozilla::dom::External>&
  SetAsExternal()
  {
    if (mType == eExternal) {
      return mValue.mExternal.Value();
    }
    Uninit();
    mType = eExternal;
    return mValue.mExternal.SetValue();
  }

  inline bool
  IsExternal() const
  {
    return mType == eExternal;
  }

  inline NonNull<mozilla::dom::External>&
  GetAsExternal()
  {
    MOZ_RELEASE_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  inline mozilla::dom::External&
  GetAsExternal() const
  {
    MOZ_RELEASE_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  inline mozilla::dom::WindowProxyHolder&
  RawSetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline mozilla::dom::WindowProxyHolder&
  SetAsWindowProxy()
  {
    if (mType == eWindowProxy) {
      return mValue.mWindowProxy.Value();
    }
    Uninit();
    mType = eWindowProxy;
    return mValue.mWindowProxy.SetValue();
  }

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline mozilla::dom::WindowProxyHolder&
  GetAsWindowProxy()
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline WindowProxyHolder const&
  GetAsWindowProxy() const
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eExternal: {
        DestroyExternal();
        break;
      }
      case eWindowProxy: {
        DestroyWindowProxy();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToExternal(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToExternal(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyExternal()
  {
    MOZ_RELEASE_ASSERT(IsExternal(), "Wrong type!");
    mValue.mExternal.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToWindowProxy(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWindowProxy(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyWindowProxy()
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    mValue.mWindowProxy.Destroy();
    mType = eUninitialized;
  }
};


class OwningExternalOrWindowProxy : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningExternalOrWindowProxy& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eExternal,
    eWindowProxy
  };
public:
  enum class Type
  {
    eExternal = TypeOrUninit::eExternal,
    eWindowProxy = TypeOrUninit::eWindowProxy
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::External> > mExternal;
    UnionMember<mozilla::dom::WindowProxyHolder > mWindowProxy;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningExternalOrWindowProxy()
    : mType(eUninitialized)
  {
  }

  OwningExternalOrWindowProxy(OwningExternalOrWindowProxy&& aOther);

  explicit inline OwningExternalOrWindowProxy(const OwningExternalOrWindowProxy& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningExternalOrWindowProxy()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::External>&
  RawSetAsExternal();

  OwningNonNull<mozilla::dom::External>&
  SetAsExternal();

  inline bool
  IsExternal() const
  {
    return mType == eExternal;
  }

  inline OwningNonNull<mozilla::dom::External>&
  GetAsExternal()
  {
    MOZ_RELEASE_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  inline OwningNonNull<mozilla::dom::External> const &
  GetAsExternal() const
  {
    MOZ_RELEASE_ASSERT(IsExternal(), "Wrong type!");
    return mValue.mExternal.Value();
  }

  mozilla::dom::WindowProxyHolder&
  RawSetAsWindowProxy();

  mozilla::dom::WindowProxyHolder&
  SetAsWindowProxy();

  inline bool
  IsWindowProxy() const
  {
    return mType == eWindowProxy;
  }

  inline mozilla::dom::WindowProxyHolder&
  GetAsWindowProxy()
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  inline mozilla::dom::WindowProxyHolder const &
  GetAsWindowProxy() const
  {
    MOZ_RELEASE_ASSERT(IsWindowProxy(), "Wrong type!");
    return mValue.mWindowProxy.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningExternalOrWindowProxy&
  operator=(OwningExternalOrWindowProxy&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningExternalOrWindowProxy&
  operator=(const OwningExternalOrWindowProxy& aOther);

private:
  bool
  TrySetToExternal(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToExternal(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyExternal();

  bool
  TrySetToWindowProxy(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToWindowProxy(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyWindowProxy();
};


class IdleRequestCallback : public CallbackFunction
{
public:
  explicit inline IdleRequestCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdleRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdleRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IdleRequestCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, IdleDeadline& deadline, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "IdleRequestCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, deadline, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(IdleDeadline& deadline, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "IdleRequestCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, deadline, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, IdleDeadline& deadline, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, deadline, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(IdleDeadline& deadline, const char* aExecutionReason = nullptr)
  {
    return Call(deadline, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const IdleRequestCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, IdleDeadline& deadline, ErrorResult& aRv);
};


namespace binding_detail {
class FastIdleRequestCallback : public IdleRequestCallback
{
public:
  explicit inline FastIdleRequestCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : IdleRequestCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    IdleRequestCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    IdleRequestCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct IdleRequestOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mTimeout;

  IdleRequestOptions();

  explicit inline IdleRequestOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  IdleRequestOptions(IdleRequestOptions&& aOther) = default;

  explicit inline IdleRequestOptions(const IdleRequestOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  IdleRequestOptions&
  operator=(const IdleRequestOptions& aOther);

  bool
  operator==(const IdleRequestOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, IdleRequestOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastIdleRequestOptions : public IdleRequestOptions
{
  inline FastIdleRequestOptions()
    : IdleRequestOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class PromiseDocumentFlushedCallback : public CallbackFunction
{
public:
  explicit inline PromiseDocumentFlushedCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline PromiseDocumentFlushedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline PromiseDocumentFlushedCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline PromiseDocumentFlushedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "PromiseDocumentFlushedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, aRetVal, aRv);
  }

  inline void
  Call(JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "PromiseDocumentFlushedCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRetVal, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  inline void
  Call(JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const PromiseDocumentFlushedCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastPromiseDocumentFlushedCallback : public PromiseDocumentFlushedCallback
{
public:
  explicit inline FastPromiseDocumentFlushedCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : PromiseDocumentFlushedCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    PromiseDocumentFlushedCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    PromiseDocumentFlushedCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct ScrollOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ScrollBehavior mBehavior;

  ScrollOptions();

  explicit inline ScrollOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ScrollOptions(ScrollOptions&& aOther) = default;

  explicit inline ScrollOptions(const ScrollOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollOptions&
  operator=(const ScrollOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ScrollOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollOptions : public ScrollOptions
{
  inline FastScrollOptions()
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SizeToContentConstraints : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mMaxHeight;
  MOZ_INIT_OUTSIDE_CTOR int32_t mMaxWidth;
  MOZ_INIT_OUTSIDE_CTOR int32_t mPrefWidth;

  SizeToContentConstraints();

  explicit inline SizeToContentConstraints(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SizeToContentConstraints(SizeToContentConstraints&& aOther) = default;

  explicit inline SizeToContentConstraints(const SizeToContentConstraints& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SizeToContentConstraints&
  operator=(const SizeToContentConstraints& aOther);

  bool
  operator==(const SizeToContentConstraints& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, SizeToContentConstraintsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSizeToContentConstraints : public SizeToContentConstraints
{
  inline FastSizeToContentConstraints()
    : SizeToContentConstraints(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WindowPostMessageOptions : public StructuredSerializeOptions
{
  MOZ_INIT_OUTSIDE_CTOR nsString mTargetOrigin;

  WindowPostMessageOptions();

  explicit inline WindowPostMessageOptions(const FastDictionaryInitializer& )
    : StructuredSerializeOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WindowPostMessageOptions(WindowPostMessageOptions&& aOther) = default;

private:
  WindowPostMessageOptions(const WindowPostMessageOptions&) = delete;
  WindowPostMessageOptions& operator=(const WindowPostMessageOptions&) = delete;

  static bool
  InitIds(JSContext* cx, WindowPostMessageOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  bool
  operator==(const WindowPostMessageOptions& aOther) const;
};

namespace binding_detail {
struct FastWindowPostMessageOptions : public WindowPostMessageOptions
{
  inline FastWindowPostMessageOptions()
    : WindowPostMessageOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ScrollToOptions : public ScrollOptions
{
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mLeft;
  MOZ_INIT_OUTSIDE_CTOR Optional<double> mTop;

  ScrollToOptions();

  explicit inline ScrollToOptions(const FastDictionaryInitializer& )
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ScrollToOptions(ScrollToOptions&& aOther) = default;

  explicit inline ScrollToOptions(const ScrollToOptions& aOther)
    : ScrollOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollToOptions&
  operator=(const ScrollToOptions& aOther);

  bool
  operator==(const ScrollToOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ScrollToOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollToOptions : public ScrollToOptions
{
  inline FastScrollToOptions()
    : ScrollToOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Window_Binding {

  typedef nsGlobalWindowInner NativeType;

  static const uint16_t STATE_MAXIMIZED = 1;
  static const uint16_t STATE_MINIMIZED = 2;
  static const uint16_t STATE_NORMAL = 3;
  static const uint16_t STATE_FULLSCREEN = 4;
  bool
  CountMaybeMissingProperty(JS::Handle<JSObject*> proxy, JS::Handle<jsid> id);

  bool
  Wrap(JSContext* aCx, nsGlobalWindowInner* aObject, nsWrapperCache* aCache, JS::RealmOptions& aOptions, JSPrincipals* aPrincipal, bool aInitStandardClasses, JS::MutableHandle<JSObject*> aReflector);

  bool
  ClearCachedDocumentValue(JSContext* aCx, nsGlobalWindowInner* aObject);

  bool
  ClearCachedPerformanceValue(JSContext* aCx, nsGlobalWindowInner* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Window,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Window,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Window,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

  extern const CrossOriginProperties sCrossOriginProperties;

} // namespace Window_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_WindowBinding_h
