// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_glean_Pings_h
#define mozilla_glean_Pings_h

#include "mozilla/glean/bindings/Ping.h"

namespace mozilla::glean_pings {

/*
 * Generated from messaging-system.
 *
 * This is a ping representing single events triggered by the messaging system
 * and captures some pings from About:Welcome, ASRouter, and other corners.
 */
constexpr glean::impl::Ping MessagingSystem(1);

/*
 * Generated from newtab.
 *
 * Newtab-related instrumentation.
 * Can be disabled via the `browser.newtabpage.ping.enabled` pref.
 */
constexpr glean::impl::Ping Newtab(2);

/*
 * Generated from newtab-content.
 *
 * Private Newtab-related instrumentation sent over OHTTP
 * Can be disabled via the `newtabPingEnabled` variable of the `glean` Nimbus
 * feature, or the `browser.newtabpage.ping.enabled` pref.
 */
constexpr glean::impl::Ping NewtabContent(3);

/*
 * Generated from spoc.
 *
 * A ping for submitting the pocket sponsored content's `shim`.
 * Does not contain a `client_id`.
 */
constexpr glean::impl::Ping Spoc(4);

/*
 * Generated from top-sites.
 *
 * A ping representing a single event happening with or to a TopSite.
 * Distinguishable by its `ping_type`.
 * Does not contain a `client_id`, preferring a `context_id` instead.
 */
constexpr glean::impl::Ping TopSites(5);

/*
 * Generated from pocket-button.
 *
 * Reinstrumentation of the Activity Stream "pocket-button" ping.
 * Submitted when actions are taken around the pocket button.
 * Does not contain any `client_id`.
 * Instead uses an `impression_id`.
 */
constexpr glean::impl::Ping PocketButton(6);

/*
 * Generated from search-with.
 *
 * A ping representing a "This time, search with" event with a partner search.
 * Does not contain a `client_id`, preferring a `context_id` instead.
 * The `context_id` is used internally for counting unique sers as well as for
 * anti-fraud. It is shared with other Contextual Services. It is not shared
 * externally.
 */
constexpr glean::impl::Ping SearchWith(7);

/*
 * Generated from serp-categorization.
 *
 * A ping representing a series of SERP loads that have been categorized. Does
 * not contain `client_id`. Is sent after a threshold of SERP loads is reached.
 */
constexpr glean::impl::Ping SerpCategorization(8);

/*
 * Generated from quick-suggest.
 *
 * A ping representing an impression, selection, or dismissmal of an AMP
 * suggestion. It contains metrics in the `quick_suggest` category. Its type is
 * defined in the `ping_type` metric. It does not contain a `client_id`,
 * preferring a `context_id` instead. `follows_collection_enabled` is set to
 * false because the ping is conditioned on Suggest and AMP suggestions being
 * enabled. It will be enabled when Suggest and AMP suggestions are enabled and
 * it will be disabled otherwise. When it becomes disabled, a separate
 * `quick-suggest-deletion-request` ping will be submitted.
 */
constexpr glean::impl::Ping QuickSuggest(9);

/*
 * Generated from quick-suggest-deletion-request.
 *
 * This ping is submitted when either AMP suggestions or the entire Suggest
 * feature becomes disabled. Like the `quick-suggest` ping, it will contain a
 * `context_id` metric in the `quick_suggest` category.
 */
constexpr glean::impl::Ping QuickSuggestDeletionRequest(10);

/*
 * Generated from urlbar-keyword-exposure.
 *
 * This ping is submitted only when urlbar keyword exposures are enabled. See
 * the `keywordExposureResults` urlbar Nimbus variable. When enabled, the ping
 * is submitted at the end of urlbar sessions during which one or more exposure
 * results are matched. (A "session" begins when the user focuses the urlbar
 * and ends with an engagement or abandonment.) Exposure results include all
 * results defined in the `exposureResults` variable. They also include the
 * "rust_exposure" result type if the `quickSuggestDynamicSuggestionTypes`
 * variable is defined with a value that includes any hidden-exposure
 * suggestion types. The ping will contain one `urlbar.keyword_exposure` event
 * for each instance where a result is matched during the session. The ping is
 * not submitted for sessions in private windows.
 */
constexpr glean::impl::Ping UrlbarKeywordExposure(11);

/*
 * Generated from context-id-deletion-request.
 *
 * This ping is submitted when a context ID has been rotated. A rotation may
 * occur because a user has disabled a surface that uses the context ID, or
 * because the context ID age has exceeded some threshold.
 */
constexpr glean::impl::Ping ContextIdDeletionRequest(12);

/*
 * Generated from prototype-no-code-events.
 *
 * **Prototype-only ping not for general use!**
 * Transport for no-code Firefox Desktop frontend instrumentation,
 * should mostly contain no-code events in browser.ui.* categories.
 * Submitted whenever the next flow of events begins (including startup).
 */
constexpr glean::impl::Ping PrototypeNoCodeEvents(13);

/*
 * Generated from pageload.
 *
 * Instrumentation collected during a page load.
 */
constexpr glean::impl::Ping Pageload(14);

/*
 * Generated from use-counters.
 *
 * Collects counts of uses of web platform features.
 * See [Use Counters Documentation](https://firefox-source-docs.mozilla.org/dom/use-counters.html)
 * for more information.
 */
constexpr glean::impl::Ping UseCounters(15);

/*
 * Generated from fx-accounts.
 *
 * A ping for information about Mozilla Account usage. Sent at the same cadence
 * as the baseline ping.
 */
constexpr glean::impl::Ping FxAccounts(16);

/*
 * Generated from bounce-tracking-protection.
 *
 * A ping representing Bounce Tracking Protection stats.  Note that this
 * ping does not include client_id.  More details are available in Bug 1889444
 */
constexpr glean::impl::Ping BounceTrackingProtection(17);

/*
 * Generated from hang-report.
 *
 * This ping is used to report when BackgroundHangReporter has detected that
 * the browser was unresponsive.
 * BackgroundHangReporter is only enabled for pre-release channels (currently
 * only on Nightly), and only on specific threads (main, renderer).
 * Whenever a runnable starts being processed on the event loop, BHR starts a
 * 128ms timer. If the runnable finishes quickly enough and execution returns
 * to the event loop before the timer fired, the timer is canceled.
 * When the timer fires, the execution is paused and a profiler stack is
 * captured. These stacks contain native frames (which need to be symbolicated
 * to become readable), label frames, and JavaScript frame, giving detailed
 * information about what was on the stack at the time the timer fired.
 * Once the stack has been recorded, execution resumes, and the total time it
 * took to finish the hanging task and return to the event loop is recorded.
 * If the execution didn't return to the event loop after 8 seconds, we assume
 * we have a 'perma-hang' that we will not be able to recover from, and record
 * the duration as 8 seconds.
 * Stack are sanitized to not reveal any information about remote content.
 * Pings are submitted daily when idle, during clean shutdowns or when 50
 * reports have been accumulated.
 */
constexpr glean::impl::Ping HangReport(18);

/*
 * Generated from background-tasks.
 *
 * This ping is generic for background tasks. Each background task can
 * gather its metrics under this ping and submit it when the task finishes.
 * Note that the ping submission must be done manually.
 */
constexpr glean::impl::Ping BackgroundTasks(19);

/*
 * Generated from captcha-detection.
 *
 * This ping is used to analyze the occurrence of CAPTCHAs in the wild
 * by users' protection settings.
 */
constexpr glean::impl::Ping CaptchaDetection(20);

/*
 * Generated from crash.
 *
 * A ping to report crash information. This information is sent as soon as possible after a crash occurs (whether the crash is a background/content process or the main process). It is expected to be used for crash report analysis and to reduce blind spots in crash reporting.
 */
constexpr glean::impl::Ping Crash(21);

/*
 * Generated from dau-reporting.
 *
 * Minimal ping to measure DAU.
 * Sent on the baseline schedule.
 * 
 * **NOTE**: This ping is deprecated and replaced by the `usage-reporting` ping.
 */
constexpr glean::impl::Ping DauReporting(22);

/*
 * Generated from collection-disabled-ping.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping CollectionDisabledPing(23);

/*
 * Generated from disabled-ping.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping DisabledPing(24);

/*
 * Generated from one-ping-only.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping OnePingOnly(25);

/*
 * Generated from ride-along-ping.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping RideAlongPing(26);

/*
 * Generated from test-ohttp-ping.
 *
 * This ping is for tests only.
 * Resembles how OHTTP pings are defined.
 */
constexpr glean::impl::Ping TestOhttpPing(27);

/*
 * Generated from test-ping.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping TestPing(28);

/*
 * Generated from heartbeat.
 *
 * Reports the user's response to a Firefox Heartbeat survey,
 * after the survey is complete.
 * ("response" includes ignoring or abandoning the survey.)
 */
constexpr glean::impl::Ping Heartbeat(29);

/*
 * Generated from nimbus-targeting-context.
 *
 * Sent by Nimbus during every experiment update cycle.
 */
constexpr glean::impl::Ping NimbusTargetingContext(30);

/*
 * Generated from broken-site-report.
 *
 * A ping containing the data for a user-initiated report for a broken site.
 * Does not contain a `client_id`. All report data is self-contained.
 */
constexpr glean::impl::Ping BrokenSiteReport(31);

/*
 * Generated from user-characteristics.
 *
 * A ping representing user hardware and software settings.  Note that this
 * ping does not include client_id.  More details are available in Bug 1879151
 */
constexpr glean::impl::Ping UserCharacteristics(32);

/*
 * Generated from onboarding-opt-out.
 *
 * This ping is submitted when a user opts out of sending Firefox
 * technical and usage telemetry to Mozilla specifically during
 * preonboarding.  (After preonboarding, opting out of sending
 * technical and usage telemetry triggers a `deletion-request` ping.)
 * Sent in response to user action.
 */
constexpr glean::impl::Ping OnboardingOptOut(33);

/*
 * Generated from usage-deletion-request.
 *
 * This ping is submitted when a user opts out of sending usage
 * frequency of Firefox to Mozilla.
 * Sent in response to user action.
 */
constexpr glean::impl::Ping UsageDeletionRequest(34);

/*
 * Generated from usage-reporting.
 *
 * Minimal ping to measure the usage frequency of Firefox.
 * Sent on the baseline schedule.
 */
constexpr glean::impl::Ping UsageReporting(35);

/*
 * Generated from first-startup.
 *
 * Sent during startup if Firefox was launched by the installer.
 */
constexpr glean::impl::Ping FirstStartup(36);

/*
 * Generated from default-agent.
 *
 * This opt-out ping is sent from the Default Agent, which is a Windows-only Firefox Background Task that is registered during Firefox installation with the Windows scheduled tasks system so that it runs automatically every 24 hours, whether Firefox is running or not.
 * Opting out of telemetry is handled via the pref value being copied to the registry so that the Default Agent can read it without needing to work with profiles. Relevant policies are consulted as well. The agent also has its own pref, `default-agent.enabled`, which if set to false disables all agent functionality, including generating this ping.
 * Each installation of Firefox has its own copy of the agent and its own scheduled task which shares a common `LastPingSentAt` user registry key with other installations. Installations race to send a single ping per 24 hour window per installing user. If multiple operating system-level users are all using one copy of Firefox, only one scheduled task will have been created and only one ping will be sent, even though the users might have different default browser settings. If multiple users have installed Firefox then each installing user will have a scheduled task and ping.
 * Additional information for the Default Agent can be found in the [Default Browser Agent docs](https://firefox-source-docs.mozilla.org/toolkit/mozapps/defaultagent/default-browser-agent/index.html).
 */
constexpr glean::impl::Ping DefaultAgent(37);

/*
 * Generated from background-update.
 *
 * This ping measures the technical health of the background update system.
 * Said system downloads and processes updates when Firefox is not running.  It
 * is expected that this ping will be analyzed by humans to gain confidence in
 * the implementation as the staged rollout of the system proceeds to the
 * release channel, before settling into an automated analysis to detect spikes
 * in background update failure rates.  This ping will also help to
 * characterize the update-related settings of our user population.
 * 
 * Right now the background update system, and therefore this ping, is
 * restricted to Windows.
 * 
 * This ping is submitted only by the background update task.  It should be
 * submitted once per background update task invocation.  The expected schedule
 * is every 7 hours, controlled by the pref `app.update.background.interval`,
 * and subject to scheduling decisions made by the OS.
 */
constexpr glean::impl::Ping BackgroundUpdate(38);


}  // namespace mozilla::glean_pings

#endif  // mozilla_glean_Pings_h
