// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanServicesSyncModulesMetrics_h
#define mozilla_GleanServicesSyncModulesMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace deletion_request {
  /**
   * generated from deletion.request.sync_device_id
   * An identifier used by sync ping, to identify the current Firefox profile for a specific Account. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.sync_device_id.
   */
  constexpr impl::StringMetric sync_device_id(537);
}

namespace synced_tabs {
  /**
   * generated from synced_tabs.click_fxa_app_menu
   */
  struct ClickFxaAppMenuExtra {
    mozilla::Maybe<nsCString> filter;
    mozilla::Maybe<nsCString> tabPos;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filter) {
        extraKeys.AppendElement()->AssignASCII("filter");
        extraValues.EmplaceBack(filter.value());
      }
      if (tabPos) {
        extraKeys.AppendElement()->AssignASCII("tab_pos");
        extraValues.EmplaceBack(tabPos.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record how users access and use synced tabs component This event was generated to correspond to the Legacy Telemetry event synced_tabs.click#fxa_app_menu.
   */
  constexpr impl::EventMetric<ClickFxaAppMenuExtra> click_fxa_app_menu(901);

  /**
   * generated from synced_tabs.click_fxa_avatar_menu
   */
  struct ClickFxaAvatarMenuExtra {
    mozilla::Maybe<nsCString> filter;
    mozilla::Maybe<nsCString> tabPos;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filter) {
        extraKeys.AppendElement()->AssignASCII("filter");
        extraValues.EmplaceBack(filter.value());
      }
      if (tabPos) {
        extraKeys.AppendElement()->AssignASCII("tab_pos");
        extraValues.EmplaceBack(tabPos.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record how users access and use synced tabs component This event was generated to correspond to the Legacy Telemetry event synced_tabs.click#fxa_avatar_menu.
   */
  constexpr impl::EventMetric<ClickFxaAvatarMenuExtra> click_fxa_avatar_menu(902);

  /**
   * generated from synced_tabs.click_synced_tabs_sidebar
   */
  struct ClickSyncedTabsSidebarExtra {
    mozilla::Maybe<nsCString> filter;
    mozilla::Maybe<nsCString> tabPos;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filter) {
        extraKeys.AppendElement()->AssignASCII("filter");
        extraValues.EmplaceBack(filter.value());
      }
      if (tabPos) {
        extraKeys.AppendElement()->AssignASCII("tab_pos");
        extraValues.EmplaceBack(tabPos.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record how users access and use synced tabs component This event was generated to correspond to the Legacy Telemetry event synced_tabs.click#synced_tabs_sidebar.
   */
  constexpr impl::EventMetric<ClickSyncedTabsSidebarExtra> click_synced_tabs_sidebar(903);
}

namespace fxa_app_menu {
  /**
   * generated from fxa_app_menu.click_account_settings
   */
  struct ClickAccountSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#account_settings.
   */
  constexpr impl::EventMetric<ClickAccountSettingsExtra> click_account_settings(4443);

  /**
   * generated from fxa_app_menu.click_cad
   */
  struct ClickCadExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#cad.
   */
  constexpr impl::EventMetric<ClickCadExtra> click_cad(4444);

  /**
   * generated from fxa_app_menu.click_login
   */
  struct ClickLoginExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#login.
   */
  constexpr impl::EventMetric<ClickLoginExtra> click_login(4445);

  /**
   * generated from fxa_app_menu.click_monitor_cta
   */
  struct ClickMonitorCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#monitor_cta.
   */
  constexpr impl::EventMetric<ClickMonitorCtaExtra> click_monitor_cta(4446);

  /**
   * generated from fxa_app_menu.click_open_monitor
   */
  struct ClickOpenMonitorExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#open_monitor.
   */
  constexpr impl::EventMetric<ClickOpenMonitorExtra> click_open_monitor(4447);

  /**
   * generated from fxa_app_menu.click_open_send
   */
  struct ClickOpenSendExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#open_send.
   */
  constexpr impl::EventMetric<ClickOpenSendExtra> click_open_send(4448);

  /**
   * generated from fxa_app_menu.click_relay_cta
   */
  struct ClickRelayCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#relay_cta.
   */
  constexpr impl::EventMetric<ClickRelayCtaExtra> click_relay_cta(4449);

  /**
   * generated from fxa_app_menu.click_send_tab
   */
  struct ClickSendTabExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#send_tab.
   */
  constexpr impl::EventMetric<ClickSendTabExtra> click_send_tab(4450);

  /**
   * generated from fxa_app_menu.click_sync_cta
   */
  struct ClickSyncCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_cta.
   */
  constexpr impl::EventMetric<ClickSyncCtaExtra> click_sync_cta(4451);

  /**
   * generated from fxa_app_menu.click_sync_now
   */
  struct ClickSyncNowExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_now.
   */
  constexpr impl::EventMetric<ClickSyncNowExtra> click_sync_now(4452);

  /**
   * generated from fxa_app_menu.click_sync_settings
   */
  struct ClickSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_settings.
   */
  constexpr impl::EventMetric<ClickSyncSettingsExtra> click_sync_settings(4453);

  /**
   * generated from fxa_app_menu.click_sync_tabs
   */
  struct ClickSyncTabsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_tabs.
   */
  constexpr impl::EventMetric<ClickSyncTabsExtra> click_sync_tabs(4454);

  /**
   * generated from fxa_app_menu.click_sync_tabs_sidebar
   */
  struct ClickSyncTabsSidebarExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_tabs_sidebar.
   */
  constexpr impl::EventMetric<ClickSyncTabsSidebarExtra> click_sync_tabs_sidebar(4455);

  /**
   * generated from fxa_app_menu.click_toolbar_icon
   */
  struct ClickToolbarIconExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#toolbar_icon.
   */
  constexpr impl::EventMetric<ClickToolbarIconExtra> click_toolbar_icon(4456);

  /**
   * generated from fxa_app_menu.click_unver_sync_settings
   */
  struct ClickUnverSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#unver_sync_settings.
   */
  constexpr impl::EventMetric<ClickUnverSyncSettingsExtra> click_unver_sync_settings(4457);

  /**
   * generated from fxa_app_menu.click_vpn_cta
   */
  struct ClickVpnCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#vpn_cta.
   */
  constexpr impl::EventMetric<ClickVpnCtaExtra> click_vpn_cta(4458);
}

namespace fxa_avatar_menu {
  /**
   * generated from fxa_avatar_menu.click_account_settings
   */
  struct ClickAccountSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#account_settings.
   */
  constexpr impl::EventMetric<ClickAccountSettingsExtra> click_account_settings(4459);

  /**
   * generated from fxa_avatar_menu.click_cad
   */
  struct ClickCadExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#cad.
   */
  constexpr impl::EventMetric<ClickCadExtra> click_cad(4460);

  /**
   * generated from fxa_avatar_menu.click_login
   */
  struct ClickLoginExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#login.
   */
  constexpr impl::EventMetric<ClickLoginExtra> click_login(4461);

  /**
   * generated from fxa_avatar_menu.click_monitor_cta
   */
  struct ClickMonitorCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#monitor_cta.
   */
  constexpr impl::EventMetric<ClickMonitorCtaExtra> click_monitor_cta(4462);

  /**
   * generated from fxa_avatar_menu.click_open_monitor
   */
  struct ClickOpenMonitorExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#open_monitor.
   */
  constexpr impl::EventMetric<ClickOpenMonitorExtra> click_open_monitor(4463);

  /**
   * generated from fxa_avatar_menu.click_open_send
   */
  struct ClickOpenSendExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#open_send.
   */
  constexpr impl::EventMetric<ClickOpenSendExtra> click_open_send(4464);

  /**
   * generated from fxa_avatar_menu.click_relay_cta
   */
  struct ClickRelayCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#relay_cta.
   */
  constexpr impl::EventMetric<ClickRelayCtaExtra> click_relay_cta(4465);

  /**
   * generated from fxa_avatar_menu.click_send_tab
   */
  struct ClickSendTabExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#send_tab.
   */
  constexpr impl::EventMetric<ClickSendTabExtra> click_send_tab(4466);

  /**
   * generated from fxa_avatar_menu.click_sync_cta
   */
  struct ClickSyncCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_cta.
   */
  constexpr impl::EventMetric<ClickSyncCtaExtra> click_sync_cta(4467);

  /**
   * generated from fxa_avatar_menu.click_sync_now
   */
  struct ClickSyncNowExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_now.
   */
  constexpr impl::EventMetric<ClickSyncNowExtra> click_sync_now(4468);

  /**
   * generated from fxa_avatar_menu.click_sync_settings
   */
  struct ClickSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_settings.
   */
  constexpr impl::EventMetric<ClickSyncSettingsExtra> click_sync_settings(4469);

  /**
   * generated from fxa_avatar_menu.click_sync_tabs
   */
  struct ClickSyncTabsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_tabs.
   */
  constexpr impl::EventMetric<ClickSyncTabsExtra> click_sync_tabs(4470);

  /**
   * generated from fxa_avatar_menu.click_sync_tabs_sidebar
   */
  struct ClickSyncTabsSidebarExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_tabs_sidebar.
   */
  constexpr impl::EventMetric<ClickSyncTabsSidebarExtra> click_sync_tabs_sidebar(4471);

  /**
   * generated from fxa_avatar_menu.click_toolbar_icon
   */
  struct ClickToolbarIconExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#toolbar_icon.
   */
  constexpr impl::EventMetric<ClickToolbarIconExtra> click_toolbar_icon(4472);

  /**
   * generated from fxa_avatar_menu.click_unver_sync_settings
   */
  struct ClickUnverSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#unver_sync_settings.
   */
  constexpr impl::EventMetric<ClickUnverSyncSettingsExtra> click_unver_sync_settings(4473);

  /**
   * generated from fxa_avatar_menu.click_vpn_cta
   */
  struct ClickVpnCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#vpn_cta.
   */
  constexpr impl::EventMetric<ClickVpnCtaExtra> click_vpn_cta(4474);
}

namespace sync {
  /**
   * generated from sync.device_count_desktop
   * Number of desktop devices (including this device) associated with this Sync account. Recorded each time Sync successfully completes the 'clients' engine.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEAVE_DEVICE_COUNT_DESKTOP.
   */
  constexpr impl::CustomDistributionMetric device_count_desktop(4475);

  /**
   * generated from sync.device_count_mobile
   * Number of mobile devices associated with this Sync account. Recorded each time Sync successfully completes the 'clients' engine.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEAVE_DEVICE_COUNT_MOBILE.
   */
  constexpr impl::CustomDistributionMetric device_count_mobile(4476);

  /**
   * generated from sync.maintenance_fix_bookmarks
   */
  /**
   * If the last sync failed and we ran maintainenance and this sync succeeded,
   * maintenance likely fixed the issue.
   */
  constexpr impl::EventMetric<NoExtraKeys> maintenance_fix_bookmarks(4477);

  /**
   * generated from sync.maintenance_run_bookmarks
   */
  /**
   * Bookmark sync failed, and it's been long enough since our last maintenance,
   * so we're running Places maintenance.
   */
  constexpr impl::EventMetric<NoExtraKeys> maintenance_run_bookmarks(4478);
}

namespace sync_client {
  /**
   * generated from sync.client.processcommand
   */
  struct ProcesscommandExtra {
    mozilla::Maybe<nsCString> command;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> serverTime;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (command) {
        extraKeys.AppendElement()->AssignASCII("command");
        extraValues.EmplaceBack(command.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (serverTime) {
        extraKeys.AppendElement()->AssignASCII("server_time");
        extraValues.EmplaceBack(serverTime.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When the local client has any remote commands and we're processing them.
   * Almost identical to `sync.client.sendcommand` but is recorded by the
   * receiving device rather than the sending device.
   * See `sync.client.sendcommand` for more details.
   */
  constexpr impl::EventMetric<ProcesscommandExtra> processcommand(4479);

  /**
   * generated from sync.client.sendcommand
   */
  struct SendcommandExtra {
    mozilla::Maybe<nsCString> command;
    mozilla::Maybe<nsCString> deviceId;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> serverTime;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (command) {
        extraKeys.AppendElement()->AssignASCII("command");
        extraValues.EmplaceBack(command.value());
      }
      if (deviceId) {
        extraKeys.AppendElement()->AssignASCII("device_id");
        extraValues.EmplaceBack(deviceId.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (serverTime) {
        extraKeys.AppendElement()->AssignASCII("server_time");
        extraValues.EmplaceBack(serverTime.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records that Sync wrote a remote "command" to another client.
   * These are sync-specific commands for that other client to take some
   * action such as resetting Sync on that client or wiping the local sync
   * data.
   * (It is not used for FxA-specific commands like opening/closing tabs.)
   */
  constexpr impl::EventMetric<SendcommandExtra> sendcommand(4480);
}

namespace sync_merge_dialog {
  /**
   * generated from sync_merge_dialog.clicked
   */
  struct ClickedExtra {
    mozilla::Maybe<nsCString> optionClicked;
    mozilla::Maybe<nsCString> variantShown;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (optionClicked) {
        extraKeys.AppendElement()->AssignASCII("option_clicked");
        extraValues.EmplaceBack(optionClicked.value());
      }
      if (variantShown) {
        extraKeys.AppendElement()->AssignASCII("variant_shown");
        extraValues.EmplaceBack(variantShown.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Event to record that showed the user a warning for potentially merging data from multiple accounts and recorded
   */
  constexpr impl::EventMetric<ClickedExtra> clicked(4481);
}

namespace syncs {
  /**
   * generated from syncs.discarded
   * How many syncs happened which were not reported in detail
   * due to being over the number of syncs we report detailed information for.
   */
  constexpr impl::QuantityMetric discarded(4482);

  /**
   * generated from syncs.hashed_device_id
   * Hashed FxA device ID, hex string of 64 characters.
   * Not included if the user is not logged in.
   * If this changes between syncs, the "sync" ping is submitted with reason "idchanged".
   */
  constexpr impl::StringMetric hashed_device_id(4483);

  /**
   * generated from syncs.hashed_fxa_uid
   * Hashed FxA unique ID, or string of 32 zeroes.
   * If this changes between syncs, the "sync" ping is submitted with reason "idchanged".
   */
  constexpr impl::StringMetric hashed_fxa_uid(4484);

  /**
   * generated from syncs.migrations
   */

  struct MigrationsObjectItem {
    Maybe<nsCString> migration_type;
    Maybe<int64_t> entries;
    Maybe<int64_t> entriesSuccessful;
    Maybe<int64_t> extensions;
    Maybe<int64_t> extensionsSuccessful;
    Maybe<bool> openFailure;
  };

  using MigrationsObject = nsTArray<MigrationsObjectItem>;
  /**
   * The application-services developers are in the process of oxidizing parts
   * of firefox sync and the related data storage code,
   * which typically requires migrating the old storage into a new database and/or format.
   * 
   * When a migration like this occurs,
   * a record is reported in this list the next time the sync ping is submitted.
   * 
   * ```text
   *   [{
   *     migration_type: Presently this is only ever "webext-storage",
   *     entries: The number of entries/preferences in the source (legacy) database, including ones we failed to read,
   *     entriesSuccessful: he number of entries/preferences (see below) which we have successfully migrated into the destination database,
   *     extensions: The number of distinct extensions which have at least one preference in the source (legacy) database,
   *     extensionsSuccessful: The number of distinct extensions which have at least one preference in the destination (migrated) database,
   *     openFailure: A boolean flag that is true if we hit a read error prior to . This likely indicates complete corruption, or a bug in an underlying library like rusqlite,
   *   }]
   * ```
   * 
   * **Note: "entries" vs "extensions"**
   * The `webext-storage` migration record detailed above contains counts for both:
   *     * The number of “entries” detected vs successfully migrated.
   *     * The number of “extensions” detected vs successfully migrated.
   * 
   * This may seem redundant, but these refer to different (but related) things.
   * The distinction here has to do with the way the two databases store extension-storage data:
   *     * The legacy database stores one row for each
   *       (`extension_id`, `preference_name`, `preference_value`) triple.
   *       These are referred to as `entries`.
   *     * Conversely, the new database stores one row per extension,
   *       which is a pair containing both the `extension_id`,
   *       as well as a dictionary holding all preference data,
   *       and so are equivalent to extensions.
   * 
   * (The description above is a somewhat simplified view of things,
   * as it ignores a number values each database stores which is irrelevant for migration)
   * 
   * That is, entries represent each individual preference setting,
   * and extensions represent the collected set of preferences for a given extension.
   * 
   * Counts for are both of these are present as it’s likely that the disparity
   * would point to different kinds of issues with the migration code.
   */
  constexpr impl::ObjectMetric<MigrationsObject, struct MigrationsObjectTag> migrations(4485);

  /**
   * generated from syncs.session_start_date
   * When the sync telemetry session begins (the `SyncTelemetryImpl`
   * constructor runs).
   * Typically useful for ordering "sync" pings.
   */
  constexpr impl::DatetimeMetric session_start_date(4486);

  /**
   * generated from syncs.sync_node_type
   * The "node type" as reported by the token server.
   * This will not change from sync to sync.
   * May not be present if the token server omits this information.
   */
  constexpr impl::StringMetric sync_node_type(4487);

  /**
   * generated from syncs.syncs
   */

  struct SyncsObjectItemFailurereason {
    Maybe<nsCString> name;
    Maybe<int64_t> code;
    Maybe<nsCString> error;
    Maybe<nsCString> from;
  };


  struct SyncsObjectItemDevicesItem {
    Maybe<nsCString> os;
    Maybe<nsCString> version;
    Maybe<nsCString> id;
    Maybe<nsCString> device_type;
    Maybe<nsCString> syncID;
  };

  using SyncsObjectItemDevices = nsTArray<SyncsObjectItemDevicesItem>;


  struct SyncsObjectItemStatus {
    Maybe<nsCString> sync;
    Maybe<nsCString> service;
  };


  struct SyncsObjectItemEnginesItemIncomingFailedreasonsItem {
    Maybe<nsCString> name;
    Maybe<int64_t> count;
  };

  using SyncsObjectItemEnginesItemIncomingFailedreasons = nsTArray<SyncsObjectItemEnginesItemIncomingFailedreasonsItem>;


  struct SyncsObjectItemEnginesItemIncoming {
    Maybe<int64_t> applied;
    Maybe<int64_t> succeeded;
    Maybe<int64_t> failed;
    Maybe<SyncsObjectItemEnginesItemIncomingFailedreasons> failedReasons;
  };


  struct SyncsObjectItemEnginesItemOutgoingItemFailedreasonsItem {
    Maybe<nsCString> name;
    Maybe<int64_t> count;
  };

  using SyncsObjectItemEnginesItemOutgoingItemFailedreasons = nsTArray<SyncsObjectItemEnginesItemOutgoingItemFailedreasonsItem>;


  struct SyncsObjectItemEnginesItemOutgoingItem {
    Maybe<int64_t> sent;
    Maybe<int64_t> failed;
    Maybe<SyncsObjectItemEnginesItemOutgoingItemFailedreasons> failedReasons;
  };

  using SyncsObjectItemEnginesItemOutgoing = nsTArray<SyncsObjectItemEnginesItemOutgoingItem>;


  struct SyncsObjectItemEnginesItemFailurereason {
    Maybe<nsCString> name;
    Maybe<int64_t> code;
    Maybe<nsCString> error;
    Maybe<nsCString> from;
  };


  struct SyncsObjectItemEnginesItemStepsItemCountsItem {
    Maybe<nsCString> name;
    Maybe<int64_t> count;
  };

  using SyncsObjectItemEnginesItemStepsItemCounts = nsTArray<SyncsObjectItemEnginesItemStepsItemCountsItem>;


  struct SyncsObjectItemEnginesItemStepsItem {
    Maybe<nsCString> name;
    Maybe<int64_t> took;
    Maybe<SyncsObjectItemEnginesItemStepsItemCounts> counts;
  };

  using SyncsObjectItemEnginesItemSteps = nsTArray<SyncsObjectItemEnginesItemStepsItem>;


  struct SyncsObjectItemEnginesItemValidationFailurereason {
    Maybe<nsCString> name;
    Maybe<int64_t> code;
    Maybe<nsCString> error;
    Maybe<nsCString> from;
  };


  struct SyncsObjectItemEnginesItemValidationProblemsItem {
    Maybe<nsCString> name;
    Maybe<int64_t> count;
  };

  using SyncsObjectItemEnginesItemValidationProblems = nsTArray<SyncsObjectItemEnginesItemValidationProblemsItem>;


  struct SyncsObjectItemEnginesItemValidation {
    Maybe<int64_t> checked;
    Maybe<SyncsObjectItemEnginesItemValidationFailurereason> failureReason;
    Maybe<int64_t> took;
    Maybe<int64_t> version;
    Maybe<SyncsObjectItemEnginesItemValidationProblems> problems;
  };


  struct SyncsObjectItemEnginesItem {
    Maybe<nsCString> name;
    Maybe<int64_t> took;
    Maybe<nsCString> status;
    Maybe<SyncsObjectItemEnginesItemIncoming> incoming;
    Maybe<SyncsObjectItemEnginesItemOutgoing> outgoing;
    Maybe<SyncsObjectItemEnginesItemFailurereason> failureReason;
    Maybe<SyncsObjectItemEnginesItemSteps> steps;
    Maybe<SyncsObjectItemEnginesItemValidation> validation;
  };

  using SyncsObjectItemEngines = nsTArray<SyncsObjectItemEnginesItem>;


  struct SyncsObjectItem {
    Maybe<int64_t> when;
    Maybe<int64_t> took;
    Maybe<bool> didLogin;
    Maybe<nsCString> why;
    Maybe<SyncsObjectItemFailurereason> failureReason;
    Maybe<SyncsObjectItemDevices> devices;
    Maybe<SyncsObjectItemStatus> status;
    Maybe<SyncsObjectItemEngines> engines;
  };

  using SyncsObject = nsTArray<SyncsObjectItem>;
  /**
   * Recorded syncs.
   * The "sync" ping is not submitted if this is empty.
   * ```text
   *   [{
   *     when: integer ms since epoch,
   *     took: integer ms duration,
   *     didLogin: true if first sync after login,
   *     why:
   *       - "startup" if first sync after browser startup
   *       - "schedule" if it's been too long since the last sync
   *       - "score" if one of sync's trackers has a high score value indicating many changes since the last sync
   *       - "user" if the user manually triggered the sync
   *       - "tabs" if the user opened the synced tabs sidebar, triggering a sync
   *     failureReason: { // if there was an error
   *       name: {"httperror"|"networkerror"|...},
   *       code: error code for "httperror" and "networkerror" only,
   *       error: error string for "othererror" and "unexpectederror" only,
   *       from: for "autherror" only,
   *     },
   *     devices: [{ // excluded if we couldn't get a valid uid or local device id
   *       os: provided by `Services.appinfo.OS`,
   *       version: provided by `Services.appinfo.version`,
   *       id: hashed FxA device id,
   *       device_type: e.g. "mobile", "tv", etc.,
   *       syncID: hashed sync device id for device, if user is a sync user,
   *               (May be different from the FxA device ID)
   *     }, ...],
   *     status: {
   *       sync: value of the Status.sync property, unless we succeeded,
   *       service: value of Status.service, unless we succeeded,
   *     },
   *     engines: [{
   *       name: Engine name: "bookmarks", "tabs", etc.,
   *       took: milliseconds (optional),
   *       status: value of Status.engines, if not success,
   *       incoming: {
   *         applied: number of records applied,
   *         succeeded: number of records that applied without error,
   *         failed: number of records that failed to apply,
   *         failedReasons: [{
   *           name: Error message when trying to apply the record,
   *           count: How many times this particular error happened,
   *         }, ...],
   *       },
   *       outgoing: [{
   *         sent: Number of outgoing records sent,
   *         failed: Number that failed to send,
   *         failedReasons: [{
   *           name: Error message while trying to send the record,
   *           count: How many times this particular error happened,
   *         }],
   *       }, ...],
   *       failureReason: { // if there was an error for this specific engine
   *         name: {"httperror"|"networkerror"|...},
   *         code: error code for "httperror" and "networkerror" only,
   *         error: error string for "othererror" and "unexpectederror" only,
   *         from: for "autherror" only,
   *       },
   *       steps: [{ // Timings and counts for detailed steps that the bookmarks engine took
   *         name: Step name (e.g. "clients", "tabs", "bookmarks-buffered" see `ProgressTracker.STEPS`),
   *         took: milliseconds the step took to execute,
   *         counts: [{
   *           name: Counter name (e.g. "items", "fetchLocalTree"),
   *           count: Counter value,
   *         }, ...],
   *       }, ...],
   *       validation: { // If the engine ran validation on itself.
   *         version: integer version,
   *         checked: how many records were checked,
   *         took: non-monotonic integer duration in millis,
   *         problems: [{
   *           name: the problem (e.g. "parentChildDisagreements", "missingChildren"),
   *           count: the records with this problem,
   *         }, ...]
   *         failureReason: { // if there was an error running validation
   *           name: error name (e.g. "nserror", "unexpectederror"),
   *           code: error code for "httperror" and "networkerror" only,
   *           error: error string for "othererror" and "unexpectederror" only,
   *           from: for "autherror" only,
   *         },
   *       },
   *     }, ...]
   *   }, ...]
   * ```
   */
  constexpr impl::ObjectMetric<SyncsObject, struct SyncsObjectTag> syncs(4488);
}

template <>
inline void impl::ObjectMetric<syncs::MigrationsObject, syncs::MigrationsObjectTag>::Set(const syncs::MigrationsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.migration_type.isSome()) {
          writer.StringProperty("migration_type", *(aobjItem.migration_type));
        }
        if (aobjItem.entries.isSome()) {
          writer.IntProperty("entries", *(aobjItem.entries));
        }
        if (aobjItem.entriesSuccessful.isSome()) {
          writer.IntProperty("entriesSuccessful", *(aobjItem.entriesSuccessful));
        }
        if (aobjItem.extensions.isSome()) {
          writer.IntProperty("extensions", *(aobjItem.extensions));
        }
        if (aobjItem.extensionsSuccessful.isSome()) {
          writer.IntProperty("extensionsSuccessful", *(aobjItem.extensionsSuccessful));
        }
        if (aobjItem.openFailure.isSome()) {
          writer.BoolProperty("openFailure", *(aobjItem.openFailure));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<syncs::SyncsObject, syncs::SyncsObjectTag>::Set(const syncs::SyncsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.when.isSome()) {
          writer.IntProperty("when", *(aobjItem.when));
        }
        if (aobjItem.took.isSome()) {
          writer.IntProperty("took", *(aobjItem.took));
        }
        if (aobjItem.didLogin.isSome()) {
          writer.BoolProperty("didLogin", *(aobjItem.didLogin));
        }
        if (aobjItem.why.isSome()) {
          writer.StringProperty("why", *(aobjItem.why));
        }
        if (aobjItem.failureReason.isSome()) {
          writer.StartObjectProperty("failureReason");
          if (aobjItem.failureReason->name.isSome()) {
            writer.StringProperty("name", *(aobjItem.failureReason->name));
          }
          if (aobjItem.failureReason->code.isSome()) {
            writer.IntProperty("code", *(aobjItem.failureReason->code));
          }
          if (aobjItem.failureReason->error.isSome()) {
            writer.StringProperty("error", *(aobjItem.failureReason->error));
          }
          if (aobjItem.failureReason->from.isSome()) {
            writer.StringProperty("from", *(aobjItem.failureReason->from));
          }
          writer.EndObject();
        }
        if (aobjItem.devices.isSome()) {
          writer.StartArrayProperty("devices");
          for (const auto& aobjitemDevicesItem: *aobjItem.devices) {
            writer.StartObjectElement();
            {
              if (aobjitemDevicesItem.os.isSome()) {
                writer.StringProperty("os", *(aobjitemDevicesItem.os));
              }
              if (aobjitemDevicesItem.version.isSome()) {
                writer.StringProperty("version", *(aobjitemDevicesItem.version));
              }
              if (aobjitemDevicesItem.id.isSome()) {
                writer.StringProperty("id", *(aobjitemDevicesItem.id));
              }
              if (aobjitemDevicesItem.device_type.isSome()) {
                writer.StringProperty("device_type", *(aobjitemDevicesItem.device_type));
              }
              if (aobjitemDevicesItem.syncID.isSome()) {
                writer.StringProperty("syncID", *(aobjitemDevicesItem.syncID));
              }
            }
            writer.EndObject();

          }
          writer.EndArray();
        }
        if (aobjItem.status.isSome()) {
          writer.StartObjectProperty("status");
          if (aobjItem.status->sync.isSome()) {
            writer.StringProperty("sync", *(aobjItem.status->sync));
          }
          if (aobjItem.status->service.isSome()) {
            writer.StringProperty("service", *(aobjItem.status->service));
          }
          writer.EndObject();
        }
        if (aobjItem.engines.isSome()) {
          writer.StartArrayProperty("engines");
          for (const auto& aobjitemEnginesItem: *aobjItem.engines) {
            writer.StartObjectElement();
            {
              if (aobjitemEnginesItem.name.isSome()) {
                writer.StringProperty("name", *(aobjitemEnginesItem.name));
              }
              if (aobjitemEnginesItem.took.isSome()) {
                writer.IntProperty("took", *(aobjitemEnginesItem.took));
              }
              if (aobjitemEnginesItem.status.isSome()) {
                writer.StringProperty("status", *(aobjitemEnginesItem.status));
              }
              if (aobjitemEnginesItem.incoming.isSome()) {
                writer.StartObjectProperty("incoming");
                if (aobjitemEnginesItem.incoming->applied.isSome()) {
                  writer.IntProperty("applied", *(aobjitemEnginesItem.incoming->applied));
                }
                if (aobjitemEnginesItem.incoming->succeeded.isSome()) {
                  writer.IntProperty("succeeded", *(aobjitemEnginesItem.incoming->succeeded));
                }
                if (aobjitemEnginesItem.incoming->failed.isSome()) {
                  writer.IntProperty("failed", *(aobjitemEnginesItem.incoming->failed));
                }
                if (aobjitemEnginesItem.incoming->failedReasons.isSome()) {
                  writer.StartArrayProperty("failedReasons");
                  for (const auto& aobjitemenginesitemIncomingfailedreasonsItem: *aobjitemEnginesItem.incoming->failedReasons) {
                    writer.StartObjectElement();
                    {
                      if (aobjitemenginesitemIncomingfailedreasonsItem.name.isSome()) {
                        writer.StringProperty("name", *(aobjitemenginesitemIncomingfailedreasonsItem.name));
                      }
                      if (aobjitemenginesitemIncomingfailedreasonsItem.count.isSome()) {
                        writer.IntProperty("count", *(aobjitemenginesitemIncomingfailedreasonsItem.count));
                      }
                    }
                    writer.EndObject();

                  }
                  writer.EndArray();
                }
                writer.EndObject();
              }
              if (aobjitemEnginesItem.outgoing.isSome()) {
                writer.StartArrayProperty("outgoing");
                for (const auto& aobjitemenginesitemOutgoingItem: *aobjitemEnginesItem.outgoing) {
                  writer.StartObjectElement();
                  {
                    if (aobjitemenginesitemOutgoingItem.sent.isSome()) {
                      writer.IntProperty("sent", *(aobjitemenginesitemOutgoingItem.sent));
                    }
                    if (aobjitemenginesitemOutgoingItem.failed.isSome()) {
                      writer.IntProperty("failed", *(aobjitemenginesitemOutgoingItem.failed));
                    }
                    if (aobjitemenginesitemOutgoingItem.failedReasons.isSome()) {
                      writer.StartArrayProperty("failedReasons");
                      for (const auto& aobjitemenginesitemoutgoingitemFailedreasonsItem: *aobjitemenginesitemOutgoingItem.failedReasons) {
                        writer.StartObjectElement();
                        {
                          if (aobjitemenginesitemoutgoingitemFailedreasonsItem.name.isSome()) {
                            writer.StringProperty("name", *(aobjitemenginesitemoutgoingitemFailedreasonsItem.name));
                          }
                          if (aobjitemenginesitemoutgoingitemFailedreasonsItem.count.isSome()) {
                            writer.IntProperty("count", *(aobjitemenginesitemoutgoingitemFailedreasonsItem.count));
                          }
                        }
                        writer.EndObject();

                      }
                      writer.EndArray();
                    }
                  }
                  writer.EndObject();

                }
                writer.EndArray();
              }
              if (aobjitemEnginesItem.failureReason.isSome()) {
                writer.StartObjectProperty("failureReason");
                if (aobjitemEnginesItem.failureReason->name.isSome()) {
                  writer.StringProperty("name", *(aobjitemEnginesItem.failureReason->name));
                }
                if (aobjitemEnginesItem.failureReason->code.isSome()) {
                  writer.IntProperty("code", *(aobjitemEnginesItem.failureReason->code));
                }
                if (aobjitemEnginesItem.failureReason->error.isSome()) {
                  writer.StringProperty("error", *(aobjitemEnginesItem.failureReason->error));
                }
                if (aobjitemEnginesItem.failureReason->from.isSome()) {
                  writer.StringProperty("from", *(aobjitemEnginesItem.failureReason->from));
                }
                writer.EndObject();
              }
              if (aobjitemEnginesItem.steps.isSome()) {
                writer.StartArrayProperty("steps");
                for (const auto& aobjitemenginesitemStepsItem: *aobjitemEnginesItem.steps) {
                  writer.StartObjectElement();
                  {
                    if (aobjitemenginesitemStepsItem.name.isSome()) {
                      writer.StringProperty("name", *(aobjitemenginesitemStepsItem.name));
                    }
                    if (aobjitemenginesitemStepsItem.took.isSome()) {
                      writer.IntProperty("took", *(aobjitemenginesitemStepsItem.took));
                    }
                    if (aobjitemenginesitemStepsItem.counts.isSome()) {
                      writer.StartArrayProperty("counts");
                      for (const auto& aobjitemenginesitemstepsitemCountsItem: *aobjitemenginesitemStepsItem.counts) {
                        writer.StartObjectElement();
                        {
                          if (aobjitemenginesitemstepsitemCountsItem.name.isSome()) {
                            writer.StringProperty("name", *(aobjitemenginesitemstepsitemCountsItem.name));
                          }
                          if (aobjitemenginesitemstepsitemCountsItem.count.isSome()) {
                            writer.IntProperty("count", *(aobjitemenginesitemstepsitemCountsItem.count));
                          }
                        }
                        writer.EndObject();

                      }
                      writer.EndArray();
                    }
                  }
                  writer.EndObject();

                }
                writer.EndArray();
              }
              if (aobjitemEnginesItem.validation.isSome()) {
                writer.StartObjectProperty("validation");
                if (aobjitemEnginesItem.validation->checked.isSome()) {
                  writer.IntProperty("checked", *(aobjitemEnginesItem.validation->checked));
                }
                if (aobjitemEnginesItem.validation->failureReason.isSome()) {
                  writer.StartObjectProperty("failureReason");
                  if (aobjitemEnginesItem.validation->failureReason->name.isSome()) {
                    writer.StringProperty("name", *(aobjitemEnginesItem.validation->failureReason->name));
                  }
                  if (aobjitemEnginesItem.validation->failureReason->code.isSome()) {
                    writer.IntProperty("code", *(aobjitemEnginesItem.validation->failureReason->code));
                  }
                  if (aobjitemEnginesItem.validation->failureReason->error.isSome()) {
                    writer.StringProperty("error", *(aobjitemEnginesItem.validation->failureReason->error));
                  }
                  if (aobjitemEnginesItem.validation->failureReason->from.isSome()) {
                    writer.StringProperty("from", *(aobjitemEnginesItem.validation->failureReason->from));
                  }
                  writer.EndObject();
                }
                if (aobjitemEnginesItem.validation->took.isSome()) {
                  writer.IntProperty("took", *(aobjitemEnginesItem.validation->took));
                }
                if (aobjitemEnginesItem.validation->version.isSome()) {
                  writer.IntProperty("version", *(aobjitemEnginesItem.validation->version));
                }
                if (aobjitemEnginesItem.validation->problems.isSome()) {
                  writer.StartArrayProperty("problems");
                  for (const auto& aobjitemenginesitemValidationproblemsItem: *aobjitemEnginesItem.validation->problems) {
                    writer.StartObjectElement();
                    {
                      if (aobjitemenginesitemValidationproblemsItem.name.isSome()) {
                        writer.StringProperty("name", *(aobjitemenginesitemValidationproblemsItem.name));
                      }
                      if (aobjitemenginesitemValidationproblemsItem.count.isSome()) {
                        writer.IntProperty("count", *(aobjitemenginesitemValidationproblemsItem.count));
                      }
                    }
                    writer.EndObject();

                  }
                  writer.EndArray();
                }
                writer.EndObject();
              }
            }
            writer.EndObject();

          }
          writer.EndArray();
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanServicesSyncModulesMetrics_h
